CONTAINER fx_server
{
	NAME fx_server;

	//Basic Tab
	GROUP SERVER_GROUP_ID
	{		
		DEFAULT 1;
		GROUP
		{
			COLUMNS 2;
			REAL SERVER_WORLD_SCALE { MIN 0.001; UNIT METER; ANIM OFF; }
			REAL SERVER_PHYSICAL_SCALE { MIN 0.001; STEP 0.1; ANIM OFF;}
		}
		SEPARATOR {LINE;}
		REAL SERVER_PHYSICAL_VOXELSIZE { MIN 0.000001; STEP 0.001; CUSTOMGUI DOUBLE; DDIGITS 6; }
		REAL SERVER_PHYSICAL_VOXELSIZE_RENDER { MIN 0.000001; STEP 0.001; CUSTOMGUI DOUBLE; DDIGITS 6; }

		VECTOR SERVER_GRAVITY {}
		LONG SERVER_GLOBALSEED { MIN 0; }

		SEPARATOR {LINE;}

		LONG SERVER_TIMESTEP_MODE
		{
			CYCLE
			{
				SERVER_TIMESTEP_MODE_CFL;
				SERVER_TIMESTEP_MODE_FRAME;
				SERVER_TIMESTEP_MODE_CUSTOM;
			}
		}
		REAL SERVER_CFLSENSITIVITY { MIN 0.5; MAX 50;  STEP 0.1;}
		REAL SERVER_SECOND {MIN 0; MAX 100000; CUSTOMGUI REALSLIDER; MAXSLIDER 200; UNIT PERCENT;}
		REAL SERVER_TIMESTEP { MIN 0.00001; MAX 10.0;  STEP 0.001; CUSTOMGUI DOUBLE; DDIGITS 6;}
		LONG SERVER_MINSUBSTEPS {MIN 0; MAX 100; }
		LONG SERVER_SUBSTEPS {MIN 0; MAX 100; }
		
		SEPARATOR {LINE;}
		
		BOOL SERVER_AUTOTIME {}
		LONG SERVER_FROM {MIN 0; }
		LONG SERVER_TO {MIN 1;}	

		SEPARATOR {LINE;}

		LONG SERVER_CPUS { MIN 0; MAX 256; }

		GROUP SERVER_GROUP_GLOBALS
		{
			LONG SERVER_PARTICLES_DENSITY { MIN 0; MAX 5; }
			REAL SERVER_PARTICLES_RADIUS { MIN 1.0; MAX 5.0; CUSTOMGUI REALSLIDER;}
			LINK SERVER_PARTICLES_KERNEL { ACCEPT { fx_kernel; } }
			
			//SEPARATOR {LINE;}
		}
		GROUP SERVER_GROUP_BULLET
		{
			LONG SERVER_BULLET_MAXSUBSTEPS {MIN 0;}
			LONG SERVER_BULLET_SOLVERITERATIONS {MIN 5; }
			LONG SERVER_BULLET_BROADPHASE 
			{
				CYCLE
				{
					SERVER_BULLET_BROADPHASE_DBVT;
					SERVER_BULLET_BROADPHASE_SWEEP;
					SERVER_BULLET_BROADPHASE_SWEEP32;
				}
			}
			LONG SERVER_BULLET_DEACTIVATIONTIME {MIN 0; HIDDEN;}
		}
	}
	GROUP SERVER_GROUP_CACHE
	{
		DEFAULT 0;
		GROUP
		{
			COLUMNS 2;
			BUTTON SERVER_CACHE_FINDNODES {}			
			BUTTON SERVER_CACHE_SETUP {}
		}
		IN_EXCLUDE SERVER_CACHE_NODES
		{
			SEND_SELCHNGMSG 1;
			NUM_FLAGS 4; 
			INIT_STATE 2;
			IMAGE_01_ON 1024284;
			IMAGE_01_OFF 1024283;
			IMAGE_02_ON 1024285;
			IMAGE_02_OFF 1024283;
			IMAGE_03_ON 1024286;
			IMAGE_03_OFF 1024283;
			IMAGE_04_ON 1024287;
			IMAGE_04_OFF 1024283;
			ACCEPT { fx_channel_scalar; fx_channel_temp;fx_channel_vector; fx_channel_fuel; fx_channel_fire; fx_fluid; fx_liquid; fx_liquid_viscous; fx_particlegroup; };
		}
		
		SEPARATOR{LINE;}

		BOOL SERVER_CACHE_RENDERONLY {}
		LONG SERVER_CACHE_MODE 
		{
			ANIM OFF;
			CYCLE
			{
				SERVER_CACHE_MODE_LOAD;
				SERVER_CACHE_MODE_SAVE;
			}
		}
		BOOL SERVER_CACHE_NEWSCENE {}
		SEPARATOR{LINE;}

		LONG SERVER_CACHE_SAVE_PARTICLES
		{
			ANIM OFF;
			CYCLE
			{
				SERVER_CACHE_SAVE_PARTICLES_EFFEX;
				SERVER_CACHE_SAVE_PARTICLES_EFFEXNEW;
				SERVER_CACHE_SAVE_PARTICLES_PRT;
				//SERVER_CACHE_SAVE_PARTICLES_BGEOJSON;
				SERVER_CACHE_SAVE_PARTICLES_BGEO;
				SERVER_CACHE_SAVE_PARTICLES_BHCLASSIC;
				SERVER_CACHE_SAVE_PARTICLES_GEO;					
				SERVER_CACHE_SAVE_PARTICLES_HCLASSIC;
				SERVER_CACHE_SAVE_PARTICLES_ITBL;
				SERVER_CACHE_SAVE_PARTICLES_ATBL;
				SERVER_CACHE_SAVE_PARTICLES_BIN;
				SERVER_CACHE_SAVE_PARTICLES_PDA;
				SERVER_CACHE_SAVE_PARTICLES_PDB;
				SERVER_CACHE_SAVE_PARTICLES_PDB32;
				SERVER_CACHE_SAVE_PARTICLES_PDB64;
				SERVER_CACHE_SAVE_PARTICLES_PDC;
				SERVER_CACHE_SAVE_PARTICLES_PTC;
				SERVER_CACHE_SAVE_PARTICLES_PTS;
				SERVER_CACHE_SAVE_PARTICLES_RIB;
				SERVER_CACHE_SAVE_PARTICLES_XYZ;
				SERVER_CACHE_SAVE_PARTICLES_MC;
				SERVER_CACHE_SAVE_PARTICLES_ICE;
			}
		}
		LONG SERVER_CACHE_SAVE_GRIDS
		{
			ANIM OFF;
			CYCLE
			{
				SERVER_CACHE_SAVE_GRIDS_EFFEX;
				//SERVER_CACHE_SAVE_GRIDS_FIELD3D;
				//SERVER_CACHE_SAVE_GRIDS_OPENVDB;
				//SERVER_CACHE_SAVE_GRIDS_DTGRID;
			}
		}
		LONG SERVER_CACHE_PATHMODE 
		{
			ANIM OFF;
			CYCLE
			{
				SERVER_CACHE_PATHMODE_SCENEPATH;
				SERVER_CACHE_PATHMODE_CUSTOM;
			}
		}
		BUTTON SERVER_CACHE_FILESELECT {}
		STRING SERVER_CACHE_FILEPATH {ANIM OFF;}
		STRING SERVER_CACHE_FILENAME {ANIM OFF;}
		
		SEPARATOR {}
				
		GROUP SERVER_CACHE_LOAD
		{
			DEFAULT 1;
			BOOL SERVER_CACHE_LOAD_FRAME_INITIALISE {}
			BOOL SERVER_CACHE_LOAD_FRAME_REVERSE {}
			LONG SERVER_CACHE_LOAD_FRAME {MIN -1; }
			LONG SERVER_CACHE_LOAD_OFFSET { }
		}
		GROUP SERVER_CACHE_SAVE
		{
			DEFAULT 1;
			BOOL SERVER_CACHE_SAVE_COMPRESS {ANIM OFF; }
			LONG SERVER_CACHE_SAVE_FRAME 
			{
				ANIM OFF;
				CYCLE
				{
					SERVER_CACHE_SAVE_FRAME_SIM;
					SERVER_CACHE_SAVE_FRAME_C4D;
				}
			}
			IN_EXCLUDE SERVER_CACHE_SAVE_EXCLUDE
			{
				SEND_SELCHNGMSG 1;
				NUM_FLAGS 0; 
				ACCEPT { fx_property_scalar; fx_property_vector; };
			}
		}
	}
}